/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2008. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
package junit.awtui;

import java.awt.*;
import java.awt.image.*;
import java.net.URL;

import junit.runner.BaseTestRunner;

public class Logo extends Canvas {
	private static final long serialVersionUID = -7441174163619714998L;
	
	final private Image fImage;
	final private int fWidth;
	final private int fHeight;
	
	public Logo() {
		fImage= loadImage("logo.gif"); //$NON-NLS-1$
		MediaTracker tracker= new MediaTracker(this);
	  	tracker.addImage(fImage, 0);
		try {
			tracker.waitForAll();
		} catch (Exception e) {
			// continue on
		}

		if (fImage != null) {
			fWidth= fImage.getWidth(this);
			fHeight= fImage.getHeight(this);
		} else {
			fWidth= 20;
			fHeight= 20;
		}
		setSize(fWidth, fHeight);
	}
	
	public static Image loadImage(String name) {
		Toolkit toolkit= Toolkit.getDefaultToolkit();
		try {
			URL url= BaseTestRunner.class.getResource(name);
			return toolkit.createImage((ImageProducer) url.getContent());
		} catch (Exception ex) {
			// continue on
		}
		return null;
	}
	
	public void paint(Graphics g) {
		paintBackground(g);
		if (fImage != null) {
			g.drawImage(fImage, 0, 0, fWidth, fHeight, this);
		}
	}
	
	public void paintBackground( java.awt.Graphics g) {
		g.setColor(SystemColor.control);
		g.fillRect(0, 0, getBounds().width, getBounds().height);
	}
}